/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search.global;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.ParentSet;
import weka.classifiers.bayes.net.search.global.HillClimber;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class RepeatedHillClimber
extends HillClimber {
    static final long serialVersionUID = -7359197180460703069L;
    int m_nRuns = 10;
    int m_nSeed = 1;
    Random m_random;

    @Override
    protected void search(BayesNet bayesNet, Instances instances) throws Exception {
        double fCurrentScore;
        this.m_random = new Random(this.getSeed());
        double fBestScore = fCurrentScore = this.calcScore(bayesNet);
        BayesNet bestBayesNet = new BayesNet();
        bestBayesNet.m_Instances = instances;
        bestBayesNet.initStructure();
        this.copyParentSets(bestBayesNet, bayesNet);
        int iRun = 0;
        while (iRun < this.m_nRuns) {
            this.generateRandomNet(bayesNet, instances);
            super.search(bayesNet, instances);
            fCurrentScore = this.calcScore(bayesNet);
            if (fCurrentScore > fBestScore) {
                fBestScore = fCurrentScore;
                this.copyParentSets(bestBayesNet, bayesNet);
            }
            ++iRun;
        }
        this.copyParentSets(bayesNet, bestBayesNet);
        bestBayesNet = null;
    }

    void generateRandomNet(BayesNet bayesNet, Instances instances) {
        int nNodes = instances.numAttributes();
        int iNode = 0;
        while (iNode < nNodes) {
            ParentSet parentSet = bayesNet.getParentSet(iNode);
            while (parentSet.getNrOfParents() > 0) {
                parentSet.deleteLastParent(instances);
            }
            ++iNode;
        }
        if (this.getInitAsNaiveBayes()) {
            int iClass = instances.classIndex();
            int iNode2 = 0;
            while (iNode2 < nNodes) {
                if (iNode2 != iClass) {
                    bayesNet.getParentSet(iNode2).addParent(iClass, instances);
                }
                ++iNode2;
            }
        }
        int nNrOfAttempts = this.m_random.nextInt(nNodes * nNodes);
        int iAttempt = 0;
        while (iAttempt < nNrOfAttempts) {
            int iTail = this.m_random.nextInt(nNodes);
            int iHead = this.m_random.nextInt(nNodes);
            if (bayesNet.getParentSet(iHead).getNrOfParents() < this.getMaxNrOfParents() && this.addArcMakesSense(bayesNet, instances, iHead, iTail)) {
                bayesNet.getParentSet(iHead).addParent(iTail, instances);
            }
            ++iAttempt;
        }
    }

    void copyParentSets(BayesNet dest, BayesNet source) {
        int nNodes = source.getNrOfNodes();
        int iNode = 0;
        while (iNode < nNodes) {
            dest.getParentSet(iNode).copy(source.getParentSet(iNode));
            ++iNode;
        }
    }

    public int getRuns() {
        return this.m_nRuns;
    }

    public void setRuns(int nRuns) {
        this.m_nRuns = nRuns;
    }

    public int getSeed() {
        return this.m_nSeed;
    }

    public void setSeed(int nSeed) {
        this.m_nSeed = nSeed;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(4);
        newVector.addElement(new Option("\tNumber of runs", "U", 1, "-U <integer>"));
        newVector.addElement(new Option("\tRandom number seed", "A", 1, "-A <seed>"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement((Option)enu.nextElement());
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String sSeed;
        String sRuns = Utils.getOption('U', options);
        if (sRuns.length() != 0) {
            this.setRuns(Integer.parseInt(sRuns));
        }
        if ((sSeed = Utils.getOption('A', options)).length() != 0) {
            this.setSeed(Integer.parseInt(sSeed));
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[7 + superOptions.length];
        int current = 0;
        options[current++] = "-U";
        options[current++] = "" + this.getRuns();
        options[current++] = "-A";
        options[current++] = "" + this.getSeed();
        int iOption = 0;
        while (iOption < superOptions.length) {
            options[current++] = superOptions[iOption];
            ++iOption;
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    @Override
    public String globalInfo() {
        return "This Bayes Network learning algorithm repeatedly uses hill climbing starting with a randomly generated network structure and return the best structure of the various runs.";
    }

    public String runsTipText() {
        return "Sets the number of times hill climbing is performed.";
    }

    public String seedTipText() {
        return "Initialization value for random number generator. Setting the seed allows replicability of experiments.";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

